![[Pasted image 20250428135520.png]]
## Introduction

- **Modern Web Threats**:
    - Malware can come from legitimate websites, not just "bad" sites. Example - You go to facebook and there could be an 'Ad' that links to a malicious site. 
    - Increasing vulnerabilities from social media, mobile access, and interactive applications.
- **Solution**:
    - Cisco Secure Web Appliance offers advanced anti-malware features, web reputation filtering, and integration with third-party engines to protect against modern web threats.

---

## Core Security Features

### **1. Anti-Malware Scanning**
![[Pasted image 20250427123533.png]]

- **Components**:
    - Uses the **Cisco DVS engine** (Dynamic Vectoring and Streaming) with integrated anti-malware engines: **Webroot**, **Sophos**, and **McAfee**.
    - Scans web traffic for malware and delivers verdicts for blocking or monitoring requests.
    - Sophos and McAfee cannot run simultaneously.
- **Process**:
    - Web Reputation Filters analyze URLs and forward them to the DVS engine for further scanning if necessary.
    - Multiple malware verdicts (from different engines or the same engine) are combined, with the most restrictive action applied.
- **Verdict Priorities** (highest to lowest):
    - Virus → Trojan → Worm → Phishing URL → Adware → Other Malware → Unscannable.

---

### **2. Web Reputation Filters**

![[Pasted image 20250427123400.png]]

- **Purpose**:
    - Assigns a **Web-Based Reputation Score (WBRS)** to URLs to predict the likelihood of malware presence.
    - Scores range from **-10 to +10**:
        - **-10 to -6**: Block.
        - **-5.9 to +5.9**: Scan.
        - **6 to 10**: Allow.
- **Integration**:
    - Works with access policies, decryption policies, and Cisco data security policies.
    - Updates automatically from the **Cisco Talos Reputation Center**.
- **Parameters Analyzed**:
    - URL age, categorization, IP address information, domain registrar history, presence of downloadable content, and more.
- **Actions Based on WBRS**:
    - Access Policies: Block, Scan, or Allow.
    - Decryption Policies: Drop, Decrypt, or Pass-through.
    - Data Security Policies: Block or Monitor.

---

### **3. Cisco Advanced Malware Protection (AMP)**
![[Pasted image 20250427124011.png]]

- **Purpose**:
    - Enhances malware detection and blocking with cloud-based analysis, file reputation, and retrospection.
- **Key Features**:
    - **File Reputation**: Assigns reputation scores to files based on cloud intelligence.
    - **File Analysis**: Analyzes unknown files in a secure sandbox environment.
    - **File Retrospection**: Provides alerts if a previously clean file is later identified as malicious.
- **Deployment Options**:
    - **Public Cloud**: Files sent to Cisco AMP cloud for analysis.
    - **Private Cloud**: On-premises solution for organizations with strict file-sharing policies.
- **Communication**:
    - Files are identified by **SHA-256 hashes**, not filenames, ensuring accurate identification.
- **File Verdict Actions**:
    - Block malicious files, monitor suspicious files, or allow clean files to pass.

---

## Additional Features

### **4. Outbound Malware Scanning**

- **Purpose**:
    - Prevents malicious data from leaving the network by scanning upload requests.
- **Features**:
    - Uses the **Cisco DVS engine** to inspect outbound HTTP and decrypted HTTPS traffic.
    - Limited to anti-malware scanning (does not support Web Reputation Filters or AMP).
- **Process**:
    - Upload requests are assigned to policies based on identification profiles, URL categories, and other criteria.
    - Verdicts determine whether to block or monitor uploads.

---

### **5. Integration with Cisco XDR**

- **Purpose**:
    - Reduces time to detect and respond to threats using machine learning and behavioral analysis.
- **Capabilities**:
    - Identifies confirmed threats (99-100% confidence) and detected anomalies.
    - Integrates with other Cisco solutions like Secure Endpoint and Secure Analytics.
- **Deployment**:
    - Secure Web Appliance uploads logs to XDR, which analyzes and reports findings.

---

## **Inbound vs. Outbound Malware Policies**

- **Inbound Policies (Access Policies)**:
    - Use DVS engine, Web Reputation Filters, and AMP.
    - Flexible actions for malware detection and file analysis.
- **Outbound Policies**:
    - Use only the DVS engine for upload requests.
    - Limited to blocking or monitoring outbound traffic.

---

## **Adaptive Scanning**

- **Purpose**:
    - Automatically selects the most appropriate scanning engine for each request.
- **Benefits**:
    - Increases malware catch rate for embedded content (e.g., Flash, JavaScript).
- **Limitations**:
    - Overrides manual web reputation and anti-malware settings.

---

## **Examples of Policy Applications**

1. **Inbound Traffic**:
    - Block all malware types in the global access policy.
    - Create specific exceptions for departments (e.g., HR can download encrypted files).
2. **Outbound Traffic**:
    - Prevent the Sales department from uploading malicious content using outbound malware scan policies.

---

## Key Takeaways

- **Comprehensive Threat Protection**:
    - Web Reputation Filters, DVS engine, AMP, and third-party integrations offer layered security.
- **Dynamic and Adaptive**:
    - DCA and Adaptive Scanning enhance detection of modern threats.
- **Granular Control**:
    - AVC engine and outbound scanning provide fine-tuned control over applications and data leaving the network.
- **Cisco Talos Integration**:
    - Real-time updates ensure protection against emerging threats.